/*
 * QrfePropertyObject.cpp
 *
 *  Created on: 01.08.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfePropertyObject.h"

#include <QMetaProperty>
#include <limits.h>


int QrfePropertyEditRange::MAX = INT_MAX;
int QrfePropertyEditRange::MIN = INT_MIN;


QrfePropertyObject::QrfePropertyObject(QObject* parent)
	: QObject(parent)
{
}

QrfePropertyObject::~QrfePropertyObject()
{
}

QStringList QrfePropertyObject::propertyNames () const
{
	QStringList names;
	const QMetaObject *metaobject = this->metaObject();
	int count = metaobject->propertyCount();
	for (int i = 0; i < count; ++i)
	{
		QMetaProperty metaproperty = metaobject->property(i);
		names << QString(metaproperty.name());
	}
	foreach(QByteArray ba, dynamicPropertyNames())
	{
        names << QString::fromLatin1(ba);
	}
	return names;
}

QVariant QrfePropertyObject::property ( const QString & name ) const
{
    return QObject::property(name.toLatin1());
}

bool QrfePropertyObject::setProperty ( const QString & name, const QVariant & value )
{
    return QObject::setProperty(name.toLatin1(), value);
}

bool QrfePropertyObject::validateNewValue ( const QString & name, const QVariant& value )
{
	if(!m_validationFunctions.contains(name))
		return true;

	return m_validationFunctions.value(name)(value);
}

QrfePropertyEditType QrfePropertyObject::propertyEditType( const QString & name ) const
{
	if(!m_editInformations.contains(name))
		return EDIT_READ_ONLY;

	return m_editInformations.value(name).first;
}

QVariant QrfePropertyObject::propertyEditParams( const QString & name ) const
{
	if(!m_editInformations.contains(name))
		return QString();

	return m_editInformations.value(name).second;
}

QString QrfePropertyObject::propertyDescription( const QString & name ) const
{
	if(!m_propertyDescription.contains(name))
		return QString();

	return m_propertyDescription.value(name);
}


void QrfePropertyObject::registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QVariant param )
{
	QPair<QrfePropertyEditType,QVariant> info;
	info.first	= editType;
	info.second = param;
	m_editInformations.insert(property, info);
}

void QrfePropertyObject::registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditRange param)
{
	QVariant v;
	v.setValue<QrfePropertyEditRange>(param);

	QPair<QrfePropertyEditType,QVariant> info;
	info.first	= editType;
	info.second = v;
	m_editInformations.insert(property, info);
}

void QrfePropertyObject::registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditList param)
{
	QVariant v;
	v.setValue<QrfePropertyEditList>(param);

	QPair<QrfePropertyEditType,QVariant> info;
	info.first	= editType;
	info.second = v;
	m_editInformations.insert(property, info);
}

void QrfePropertyObject::registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditPattern param)
{
	QVariant v;
	v.setValue<QrfePropertyEditPattern>(param);

	QPair<QrfePropertyEditType,QVariant> info;
	info.first	= editType;
	info.second = v;
	m_editInformations.insert(property, info);
}

void QrfePropertyObject::registerPropertyDescription ( const QString& property, const QString& description )
{
	m_propertyDescription.insert(property, description);
}

void QrfePropertyObject::registerPropertyValidation ( const QString& property, QrfeValidationFunction validation )
{
	m_validationFunctions.insert(property, validation);
}

